# 🎉 What's new in Perforce P4 One

<div class="bg-[#89b97f59] rounded-lg px-8 py-4 mt-8">

## 2025.2.0

### :star: Clearer timeline for version management

The timeline now provides a clearer view of the state of your workspace, your changes, and changes submitted by others. Local versions now stack on your current synced changelist. When you sync, P4 One updates your files with the latest content while preserving your edits.

![images-100](assets/sync-rebase.mp4){.mx-auto}

### :star: Squash local versions

To remove redundant local backups, you can now squash local versions.

![images-100](assets/releasenotes/squash.mp4){.w-2/3 .mx-auto}

Together with the improved version timeline, you can create as many work-in-progress versions as needed without clutter in timelines for long term projects.

### Other new features

- :star: .p4ignore files can now be used with P4 One.
- :star: Use the Show Ignored Items button in the toolbar to display hidden ignored items.
- :star: When creating a workspace, choose options for collaboration or individual use.
- :star: View servers in the View menu instead of the navigation pane.
- :star: Manage workspaces in the View menu instead of the navigation pane.

### Bug fixes

- :bug: When renaming a file, entering a new file name did not work without pressing the Shift key.
- :bug: When renaming a file, using the arrow keys moved focus from the filename.
- :bug: The message displayed when P4 One could not establish the authenticity of a server did not include detailed information.
- :bug: The Show All Files button did not reflect the action correctly. The button name is now Show Folders.
- :bug: Previews of .tiff files displayed a broken image.
- :bug: Scrolling to the bottom of the Recent Workspaces list did not work.
- :bug: Clicking ignored files treated files like folders.
- :bug: Files with a leading '#' incorrectly displayed a folder thumbnail.

</div>

## 2025.1.11

### Bug fixes
- :bug: P4 One could not connect to some older versions of P4.
- :bug: Automatic updates did not work for P4 One 2025.1.9 in some cases.

## 2025.1.10 (public release)

### New features
- :star: Undo and redo actions in text fields.

### Enhancements
- :racehorse: Improve speed of file operations.

### Bug fixes
- :bug: Changelists did not have a @ prefix.
- :bug: Status icons were missing for added, modified, and deleted files.
- :bug: In the file view, opening and deleting items did not work correctly.
- :bug: In the 3D viewer, .blend files did not open correctly.
- :bug: On macOS, file previews failed when using QuickLook.
- :bug: In FBX files, textures did not load correctly.
- :bug: Some fields were not hidden in Sensitive mode.
- :bug: The user interface had some typos.

This release also contains other minor bug fixes.

## 2025.1.9 (beta)

- :star: Added new dashboard
- :star: Support for *.ogg*, *.opus*, *.m4a* and *.aac* audio files
- :star: Added support of classic depots.
- :star: Added support for ignoring items.
- :star: Added icons and tooltips for move/add and move/delete actions in pending and submitted changes view.
- :bug: Fixed workspace list to exclude auto-generated Swarm and DAM clients.
- :bug: Fixed crash when attempting to create a workspace with illegal characters.
- :bug: Fixed issues when opening or deleting items in the file view.
- :bug: Fixed case where double clicking on symlinked directory would not navigate into directory.

## 2025.1.8 (beta)

- :star: Improved the new action dialog for restoring versions. This new dialog gives a more granular control over safety guards or what to restore.

![images-100](assets/releasenotes/action-dialog-restore.png){.w-4/5 .mx-auto}

- :star: Added pending changes view.
- :star: Added a new submit dialog.
- :star: Increased button size of window handles.
- :star: Added the ability to convert Perforce workspaces into P4 One workspaces directly when browsing directories.
- :star: Add directory to list of favorites via right click.
- :star: If the user has used Perforce and is starting P4 One the first time, add their list of Perforce P4 servers.
- :racehorse: Rendering performance of the 3D viewer has increased by up to 5x, now reaching up to 60 FPS and beyond.
- :bug: Fixed issue where the wrong thumbnail is displayed for versions.
- :bug: Fixed issue with incorrectly positioned close button in file preview.
- :bug: Fixed cases where workspace wouldn't automatically refresh due to local file changes.
- :bug: Fixed crash when revealing non-existing item in File Explorer.
- :bug: Fixed crash when opening text files larger than 512 MB in the builtin text editor.
- :bug: Fixed missing streams in streams dropdown.
- :bug: Fixed missing display mode controls in 3D viewer.
- :bug: Fixed start of workspace view when connection is delayed.
- :bug: Fixed double click of file in previous version.
- :bug: Fixed issue where status icons disappeared after a refresh.

## 2025.1.7 (beta)

### :star: New action modal dialog

A new action modal dialog has been introduced, replacing multiple input dialogs. This new dialog is more intuitive and helps clarify each action's side effects. Each action is linked to your keyboard number keys 1-9 for quick access.

![images-100](assets/releasenotes/action-dialog.png){.w-4/5 .mx-auto}

### :star: Dedicated thumbnails for directories that are P4 One workspaces

On each platform, the associated folder thumbnails now have an overlay to indicate that they are a P4 One workspace.

![images-50](assets/releasenotes/folder.png){.w-3/5 .mx-auto}

### :star: New status bar and console

We've added a new status bar and console to the UI. For those who like to dig deeper, the console offers a detailed look at what’s happening behind the scenes. You can toggle it on or off by pressing <span class='font-mono bg-neutral-700 rounded-md px-1.5'>Ctrl+`</span>.

![images-100](assets/releasenotes/console.png)

### What else

- :star: Helix Authentication Services (SSO) support
- :star: Virtual streams support
- :star: Thumbnails now respect the screens color mode
- :star: Improved sidebar UI
- :star: First version of a new workspace now starts at 1, not 0.
- :racehorse: 20x faster loading of large directories
- :racehorse: Blazingly fast new thumbnail generation
- :racehorse: Improved performance when scrolling through large directories
- :bug: Fixed display issue with tooltips
- :bug: Fixed issue with item viewer
- :bug: Improved scrolling behaviour
- :bug: Hide reveal button in toolbar if not useful
- :bug: Fixed a bunch of other UI bugs and inconsistencies
- :bug: Fixed issue with drive labels on Windows
- :bug: Fix a bug where the default version message number counter only increased if previous version message contained a number.

## 2025.1.6 (beta)

- :bug: Remove broken links

## 2025.1.5 (beta)

- :bug: Fixed updater issue on Mac

## 2025.1.4 (beta)

- :bug: Fixed issues with the graph

## 2025.1.3 (beta)

- :bug: Fixed issues with broken doc links

## 2025.1.2 (beta)

- :bug: Fixed issues with the updater UI

## 2025.1.1 (beta)

- :bug: Fixed thumbnails on Windows
- :bug: Fixed broken thumbnails for Unreal Engine asset files
- :bug: Fixed broken color mode for Unreal Engine asset files
- :bug: Fixed modified times for items
- :bug: Fixed occasional issue with diff view for text files
- :bug: Fixed a few missing error messages upon user errors
- :bug: Fixed glitch where graph is cropped
- :bug: Fixed minor issues with the layout
- :bug: Fixed typos